<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class WinningBalance extends Model 
{

    protected $table = 'winning_balance';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('from_user_id', 'to_user_id', 'amount');

    public function userWinAmount()
    {
        return $this->belongsTo('User', 'from_user_id');
    }

}